import matplotlib.pyplot as plt
import numpy as np
import scipy.io as sio
import FigureSetup


csfont = {'fontname':'Times New Roman','fontsize':14}

### load experimental traces

NoGuide_350 = sio.loadmat('Exp/h_STN300_800to1600mus_incpl0.mat')
yNG_350 = -NoGuide_350['sumresult']
yNG_350_ref = -NoGuide_350['sumresult_ref']
xNG_350 = NoGuide_350['scanrange'] + NoGuide_350['expparams'][0,0]['YAGdelay'][0,0] - NoGuide_350['expparams'][0,0]['egundelay'][0,0]

Guide_350 = sio.loadmat('Exp/i_STN300_800to1600mus_incpl0_Guide.mat')
yG_350 = -Guide_350['sumresult']
yG_350_ref = -Guide_350['sumresult_ref']
xG_350 = Guide_350['scanrange'] + Guide_350['expparams'][0,0]['YAGdelay'][0,0] - Guide_350['expparams'][0,0]['egundelay'][0,0]


# ## normalize data
yNG_350_ref_norm = (yNG_350_ref-np.min(yNG_350_ref))/np.max(yNG_350_ref-np.min(yNG_350_ref))

yG_350_ref_norm = (yG_350_ref-np.min(yG_350_ref))/np.max(yNG_350_ref-np.min(yNG_350_ref))

##### Simulation Output
alldata = np.load('GuideAnalysis_Undec_vel300_DetPos319Output1_1p5_0p6_1p1_m0p2.npz')
pos_notskimmed = alldata['pos_notskimmed']
vel_notskimmed = alldata['vel_notskimmed']
times_notskimmed = alldata['times_notskimmed'] 
pos_noGuide = alldata['pos_noGuide'] 
vel_noGuide = alldata['vel_noGuide']
times_noGuide = alldata['times_noGuide'] 
tof_time_guide = alldata['tof_time_guide'] 
tof_signal_guide = alldata['tof_signal_guide'] 
tof_time_noguide = alldata['tof_time_noguide']
tof_signal_noguide = alldata['tof_signal_noguide'] 


tof_norm=np.float(np.max(tof_signal_noguide))
sim_delay = 40

fig, axs = FigureSetup.new_figure(nrows=1, ncols=1)
plt.xlim([350, 1200])
# plt.ylim([0, 0.015]3
plt.ylim([-1.05, 1.05])
# plt.yticks([0, 0.005, 0.01])
plt.yticks([-1.00,-0.5,0.00,0.5,1.0], ["1.0","0.5","0.0","0.5","1.0"])
plt.ylabel('Intensity (norm.)', **csfont)
plt.xlabel('TOF ($\mu$s)', **csfont)

axs.plot(xNG_350, yNG_350_ref_norm, '#db9d29') 
axs.plot(xG_350, yG_350_ref_norm, '#158c22') 
axs.fill_between(tof_time_noguide+sim_delay, 0, -tof_signal_noguide/tof_norm, facecolor='#db9d29', alpha=0.6, label = "No Guide")
axs.fill_between(tof_time_guide+sim_delay, 0, -tof_signal_guide/tof_norm, facecolor= '#158c22', alpha=0.6, label = "Guide")

axs.annotate('b)', (380,0.90), textcoords = 'data', size = 14)
axs.annotate("Experiment", (1000,0.20), textcoords = 'data', size = 14)
axs.annotate("Simulation", (1000,-0.25), textcoords = 'data', size = 14)
axs.legend(loc = 'upper right', prop={'size': 14})

# plt.savefig("SimExpCf_500to200.pdf", format="pdf")
# plt.savefig("Blades/350_B1_1p7.png", format = "png", dpi = 1000)
# plt.savefig("Sim_Exp_DecOn250_comparison.pdf", format = "pdf")
plt.show()
